from voice_synthesis.core.constants import Uris
from voice_synthesis.core.http_result import HttpResult
from voice_synthesis.core.http_service import HttpService
from voice_synthesis.core.logger import Logger

class CoreClient:
    def __init__(self, http_service: HttpService):
        self._http: HttpService = http_service

    async def check_healthz(self) -> bool:
        result : HttpResult = await self._http.get(Uris.Core.HEALTHZ)
        if not result.is_success:
            Logger.error(f"❌ {result.status_code}: {result.error_message}")
            return False
        return True
