class Logger:
    verbose = False

    DARK_GRAY = "\033[90m"
    CYAN = "\033[96m"
    RED = "\033[91m"
    RESET = "\033[0m"

    @staticmethod
    def debug(msg):
        if Logger.verbose:
            print(f"{Logger.DARK_GRAY}[DEBUG] {msg}{Logger.RESET}")

    @staticmethod
    def info(msg):
        print(f"{Logger.CYAN}[INFO] {msg}{Logger.RESET}")

    @staticmethod
    def error(msg):
        print(f"{Logger.RED}[ERROR] {msg}{Logger.RESET}")
