from typing import List

from voice_synthesis.core.constants import Uris
from voice_synthesis.core.http_result import HttpResult
from voice_synthesis.core.http_service import HttpService
from voice_synthesis.core.logger import Logger

class VoiceSynthesisClient:
    def __init__(self, http_service: HttpService):
        self._http: HttpService = http_service

    async def get_available_voices(self) -> List[str]:
        available_voices = []

        result : HttpResult = await self._http.get(Uris.VoiceSynthesis.GET_VOICES)
        if not result.is_success:
            Logger.error(f"❌ {result.status_code}: {result.error_message}")
            return False

        Logger.debug(f"received : {result.raw_content}")

        for key in result.data.keys():
            available_voices.append(key)

        return available_voices

    async def synthesize(self,
                        text: str,
                        voice_id: str):
        json_body = {
            "text": text,
            "voice_id": voice_id
        }

        result: HttpResult = await self._http.post(Uris.VoiceSynthesis.SYNTHESIZE, json_body)

        if not result.is_success:
            Logger.error(f"❌ {result.status_code}: {result.error_message}")
            return None

        if "token" not in result.data:
            Logger.error(f"❌ {result.status_code}: {result.error_message}")
            return None

        return result.data["token"]
