
from voice_synthesis.api.core_client import CoreClient
from voice_synthesis.api.voice_synthesis_client import VoiceSynthesisClient
from voice_synthesis.core.http_service import HttpService
from voice_synthesis.core.logger import Logger

class VdkClient:
    def __init__(self, scheme: str, host: str, port: int):
        self.scheme = scheme
        self.host = host
        self.port = port
        self.base_uri = f"{self.scheme}://{self.host}:{self.port}/v1"
        self.http = HttpService(self.base_uri)

        self.health             = CoreClient(self.http)
        self.voice_synthesis    = VoiceSynthesisClient(self.http)

        Logger.info(f"Reaching VDK service at {self.base_uri}")

    def ws_uri(self, token: str) -> str:
        return f"ws://{self.host}:{self.port}/v1/ws/{token}"

    async def close(self):
        await self.http.close()
