using System;
using System.IO;
using NAudio.Wave;


namespace VdkServiceClient.Audio
{
    public class AudioFileWriter : IDisposable
    {
        private readonly Stream _stream;
        private readonly WaveFileWriter _wavWriter;

        // pcm
        public AudioFileWriter(string filePath)
        {
            _stream = new FileStream(filePath, FileMode.Create, FileAccess.Write);
        }

        // wav
        public AudioFileWriter(string filePath, int sampleRate, int channelCount)
        {
            _wavWriter = new WaveFileWriter(filePath, new WaveFormat(sampleRate, 16, channelCount));
        }

        public void WriteChunk(byte[] data)
        {
            if (_wavWriter != null)
                _wavWriter.Write(data, 0, data.Length);
            else if (_stream != null)
                _stream.Write(data, 0, data.Length);
        }

        public void Dispose()
        {
            _wavWriter?.Dispose();
            _stream?.Dispose();
        }
    }
}