using System.Threading.Tasks;
using VdkServiceClient.Utils;
using VdkServiceClient.Http;


namespace VdkServiceClient.Api 
{ 
    /// <summary>
    /// Core API
    /// </summary>
    /// <remarks> Contains : healthz (health check)
    /// </remarks>
    /// <param name="http"> A preconfigured http client </param>
    public class CoreApi
    {
        private readonly HttpService _http;

        public CoreApi(HttpService http)
        {
            _http = http;
        }

        /// <summary>
        /// Perform a health check
        /// </summary>
        public async Task<bool> Healthz()
            {
                var response = await _http.GetAsync(Constants.Endpoints.Core.Healthz);
                if (!response.IsSuccess)
                {
                    Logger.Error($"❌ {response.StatusCode}: {response.ErrorMessage}");
                    return false;
                }

                return true;
            } // !Healthz
    } // !CoreApi
}