﻿using VdkServiceClient.Constants;
using CommandLine;

namespace VoiceSynthesis
{

    /// <summary>
    /// Command line options.
    /// </summary>
    public class Options
    {
        [Option('s', "scheme", HelpText = "Protocol to use for the VDK service (http or https).", Default = VdkService.Scheme)] public string Scheme { get; set; }
        [Option('h', "host", HelpText = "VDK service host.", Default = VdkService.Host)] public string Host { get; set; }
        [Option('p', "port", HelpText = "VDK service port.", Default = VdkService.Port)] public int Port { get; set; }
        [Option('t', "text", HelpText = "Text to synthesize.", Default = "Hello world!")] public string Text { get; set; }
        [Option('v', "voice", HelpText = "Voice id to use.")] public string Voice { get; set; }
        [Option('l', "list", HelpText = "List available voices.", Default = false)] public bool ListVoices { get; set; }
        [Option('f', "file", HelpText = "Save as audio file (wav or raw PCM 22050Hz 16bits mono) instead of playing it.")] public string Output { get; set; }
        [Option("verbose", HelpText = "Verbose mode (true to print debug messages).", Default = false)] public bool Verbose { get; set; }

        /// <summary>
        /// Validate and skip options that don't require validation and make sure the ones that do are valid.
        /// </summary>
        /// <param name="error"> The error message. </param>
        public bool Validate(out string error)
        {
            error = null;
            return true;
        }
    }
}
