namespace VdkServiceClient.Constants
{
    public static class VdkService
    {
        public const string Scheme     = "http";
        public const string Host       = "127.0.0.1";
        public const int    Port       = 39806;
        public const string ApiVersion = "v1";
    }

    public static class Endpoints
    {
        public static class Core
        {
            public const string Healthz = "/healthz";
        }

        public static class Recognition
        {
            public const string GetModels           = "/voice-recognition/models";
            public const string Recognize           = "/voice-recognition/recognize";
            public const string GetUserWords        = "/voice-recognition/userwords";
            public const string Enroll              = "/voice-recognition/userwords/enroll";
            public const string DeleteUserWords     = "/voice-recognition/userwords";
            public const string DeleteUserWordsUser = "/voice-recognition/userwords/{0}";
        }

        public static class Enhancement
        {
            public const string GetEnhancers = "/speech-enhancement/enhancers";
            public const string Enhance      = "/speech-enhancement/enhance";
        }

        public static class Biometrics
        {
            public const string GetModels       = "/voice-biometrics/models";
            public const string GetModelInfo    = "/voice-biometrics/models/{0}";
            public const string Authenticate    = "/voice-biometrics/authenticate";
            public const string Identify        = "/voice-biometrics/identify";
            public const string Enroll          = "/voice-biometrics/enroll";
            public const string DeleteModelUser = "/voice-biometrics/models/{0}/users/{1}";
            public const string DeleteModel     = "/voice-biometrics/models/{0}";
            public const string GetModelUsers   = "/voice-biometrics/models/{0}/users";
        }

        public static class Synthesis
        {
            public const string GetVoices  = "/voice-synthesis/voices";
            public const string Synthesize = "/voice-synthesis/synthesize";
        }
    }

    public static class Http
    {
        public const string JsonContentType = "application/json"; // Content Type
    }

    public static class Audio
    {
        public const string AudioPrefix = "data:audio/pcm;base64,"; // Audio prefix (pcm base64)
    }
}
