using System;
using System.Threading;
using NAudio.Wave;


namespace VdkServiceClient.Audio
{
    public class AudioRecorder : IDisposable
    {
        private readonly WaveInEvent _waveIn;
        private readonly WaveFormat _format;
        private bool _isRecording = false;

        /// <summary>
        /// Raised whenever a new audio chunk is captured.
        /// </summary>
        public event Action<AudioBuffer> OnAudioData;

        public AudioRecorder(int sampleRate, int channels)
        {
            _format = new WaveFormat(sampleRate, 16, channels);
            _waveIn = new WaveInEvent
            {
                WaveFormat = _format,
                BufferMilliseconds = 30 // period. (ms)
            };

            _waveIn.DataAvailable += (s, e) =>
            {
                var buffer = new AudioBuffer();
                buffer.Data = new byte[e.BytesRecorded];
                buffer.SampleRate = _format.SampleRate;
                buffer.Channels = _format.Channels;
                Array.Copy(e.Buffer, buffer.Data, e.BytesRecorded);
                OnAudioData?.Invoke(buffer);
            };
        }

        public void Start()
        {
            _isRecording = true;
            _waveIn.StartRecording();
        }

        public void Stop()
        {
            _isRecording = false;
            _waveIn.StopRecording();
        }

        public void WaitForCompletion()
        {
            while (_isRecording)
            {
                Thread.Sleep(100);
            }
        }

        public void Dispose()
        {
            _waveIn?.Dispose();
        }
    }
}