using System;
using System.IO;
using NAudio.Wave;


namespace VdkServiceClient.Audio
{
    public class AudioFileReader : IDisposable
    {
        private readonly WaveStream waveStream;

        public int SampleRate { get { return waveStream.WaveFormat.SampleRate; } }
        public int Channels { get { return waveStream.WaveFormat.Channels; } }

        public AudioFileReader(string filePath, int sampleRate = 16000, int channels = 1)
        {
            string ext = Path.GetExtension(filePath).ToLowerInvariant();
            if (ext == ".wav")
                waveStream = new WaveFileReader(filePath);
            else
            {
                var format = new WaveFormat(sampleRate, 16, channels);
                waveStream = new RawSourceWaveStream(File.OpenRead(filePath), format);
            }
        }

        public int Read(byte[] buffer, int offset, int count)
        {
            return waveStream.Read(buffer, offset, count);
        }

        public byte[] ReadAllBytes()
        {
            var ms = new MemoryStream();
            waveStream.CopyTo(ms);
            return ms.ToArray();
        }

        public void Dispose()
        {
            waveStream?.Dispose();
        }
    }
}