from pydantic import BaseModel, Field
from typing import List, Optional

class Item(BaseModel):
    begin_time: int = Field(..., alias="begin_time")
    end_time: int = Field(..., alias="end_time")
    confidence: int = Field(..., alias="confidence")
    orthography: Optional[str] = None
    type: Optional[str] = None
    name: Optional[str] = None
    items: Optional[List["Item"]] = None

class Hypothesis(BaseModel):
    begin_time: int = Field(..., alias="begin_time")
    end_time: int = Field(..., alias="end_time")
    confidence: int = Field(..., alias="confidence")
    items: Optional[List[Item]] = None
    start_rule: Optional[str] = Field(None, alias="start_rule")
    name: Optional[str] = None
    type: Optional[str] = None

class AsrResult(BaseModel):
    active_start_rules: Optional[List[str]] = Field(None, alias="active_start_rules")
    begin_time: int = Field(..., alias="begin_time")
    end_time: int = Field(..., alias="end_time")
    hypotheses: Optional[List[Hypothesis]] = None
    is_final: bool = Field(..., alias="is_final")
    type: int
    type_string: Optional[str] = Field(None, alias="type_string")

# Résolution récursive
Item.model_rebuild()
Hypothesis.model_rebuild()
AsrResult.model_rebuild()

class VoiceBiometricsModelData:
    def __init__(self, name, type, users):
        self.name = name
        self.type = type
        self.users = users

    def __repr__(self):
        return f"VoiceBiometricsModelData(Name={self.name}, Type={self.type}, Users={self.users})"
