
from voice_biometrics.api.core_client import CoreClient
from voice_biometrics.api.voice_biometrics_client import VoiceBiometricsClient
from voice_biometrics.core.http_service import HttpService
from voice_biometrics.core.logger import Logger

class VdkClient:
    def __init__(self, scheme: str, host: str, port: int):
        self.scheme = scheme
        self.host = host
        self.port = port
        self.base_uri = f"{self.scheme}://{self.host}:{self.port}/v1"
        self.http = HttpService(self.base_uri)

        self.health             = CoreClient(self.http)
        self.voice_biometrics   = VoiceBiometricsClient(self.http)

        Logger.info(f"Reaching VDK service at {self.base_uri}")

    def ws_uri(self, token: str) -> str:
        return f"ws://{self.host}:{self.port}/v1/ws/{token}"

    async def close(self):
        await self.http.close()
