using System;
using System.IO;
using System.Json;
using System.Runtime.CompilerServices;

namespace VdkServiceClient.Utils
{
    public static class Logger
    {
        private static bool Verbose = false;

        public static void SetVerbose(bool verbose)
        {
            Verbose = verbose;
        }

        public static void Info(string message)
        {
            Console.ForegroundColor = ConsoleColor.Cyan;
            Console.WriteLine($"{GetTimestamp()} [INFO] {message}");
            Console.ResetColor();
        }

        public static void Info(JsonValue json)
        {
            JsonValue clone = JsonValue.Parse(json.ToString());
            if (clone is JsonObject obj && obj.ContainsKey("data"))
            {
                obj["data"] = "base64AudioData";
            }

            Info(clone.ToString());
        }

        public static void Debug(string message)
        {
            if (Verbose)
            {
                Console.ForegroundColor = ConsoleColor.DarkGray;
                Console.WriteLine($"{GetTimestamp()} [DEBUG] {message}");
                Console.ResetColor();
            }
        }

        public static void Debug(JsonValue json)
        {
            JsonValue clone = JsonValue.Parse(json.ToString());
            if (clone is JsonObject obj && obj.ContainsKey("data"))
            {
                obj["data"] = "base64AudioData";
            }

            Debug(clone.ToString());
        }

        public static void Error(string message, Exception ex = null, [CallerFilePath] string file = "",
                                 [CallerMemberName] string member = "", [CallerLineNumber] int line = 0)
        {
            Console.ForegroundColor = ConsoleColor.Red;
            Console.WriteLine(
                $"{GetTimestamp()} [ERROR] [{Path.GetFileName(file)}:{line} → {member}] {ex?.GetType().Name}: {message}");
            Console.ResetColor();
        }

        private static string GetTimestamp()
        {
            return DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss.fff");
        }
    }
}