from speech_enhancement.audio.audio_utils import AudioFormat

B64_PCM_PREFIX = "data:audio/pcm;base64,"

# API default values
class Defaults:
    DEFAULT_VDK_SCHEME = "http"
    DEFAULT_VDK_HOST   = "127.0.0.1"
    DEFAULT_VDK_PORT   = 39806

    DEFAULT_AUDIO_FORMAT = AudioFormat(16000, 1, 16)

class Uris:
    class Core:
        HEALTHZ = "/healthz"

    class VoiceRecognition:
        GET_MODELS = "/voice-recognition/models"
        RECOGNIZE = "/voice-recognition/recognize"

    class VoiceSynthesis:
        GET_VOICES = "/voice-synthesis/voices"
        SYNTHESIZE = "/voice-synthesis/synthesize"

    class SpeechEnhancement:
        GET_ENHANCERS = "/speech-enhancement/enhancers"
        ENHANCE = "/speech-enhancement/enhance"

    class VoiceBiometrics:
        GET_MODELS = "/voice-biometrics/models"
        GET_MODEL_INFO = "/voice-biometrics/models/{model}"
        GET_MODEL_USERS = "/voice-biometrics/models/{model}/users"
        AUTHENTICATE = "/voice-biometrics/authenticate"
        IDENTIFY = "/voice-biometrics/identify"
        ENROLL = "/voice-biometrics/enroll"
        DELETE_MODEL_USER = "/voice-biometrics/models/{model}/users/{user}"
        DELETE_MODEL = "/voice-biometrics/models/{model}"
