from typing import List

from app.core.constants import Uris
from app.core.http_result import HttpResult
from app.core.http_service import HttpService
from app.core.logger import Logger

class SpeechEnhancementClient:
    def __init__(self, http_service: HttpService):
        self._http: HttpService = http_service

    async def get_available_enhancers(self) -> List[str]:
        available_enhancers = []

        result : HttpResult = await self._http.get(Uris.SpeechEnhancement.GET_ENHANCERS)
        if not result.is_success:
            Logger.error(f"❌ {result.status_code}: {result.error_message}")
            return False

        Logger.debug(f"received : {result.raw_content}")

        for enhancer in result.data["enhancers"]:
            available_enhancers.append(enhancer)

        return available_enhancers

    async def enhance(self,
                        enhancer: str):
        json_body = {
            "speech_enhancer": enhancer
        }

        result: HttpResult = await self._http.post(Uris.SpeechEnhancement.ENHANCE, json_body)

        if not result.is_success:
            Logger.error(f"❌ {result.status_code}: {result.error_message}")
            return None

        if "token" not in result.data:
            Logger.error(f"❌ {result.status_code}: {result.error_message}")
            return None

        return result.data["token"]
