from speech_enhancement.core.constants import Uris
from speech_enhancement.core.http_result import HttpResult
from speech_enhancement.core.http_service import HttpService
from speech_enhancement.core.logger import Logger

class CoreClient:
    def __init__(self, http_service: HttpService):
        self._http: HttpService = http_service

    async def check_healthz(self) -> bool:
        result : HttpResult = await self._http.get(Uris.Core.HEALTHZ)
        if not result.is_success:
            Logger.error(f"❌ {result.status_code}: {result.error_message}")
            return False
        return True
