﻿using System.IO;
using VdkServiceClient.Constants;
using CommandLine;

namespace SpeechEnhancement
{
    public class Options
    {

        [Option('s', "scheme", HelpText = "Protocol to use for the VDK service (http or https).", Default = VdkService.Scheme)] public string Scheme { get; set; }
        [Option('h', "host", HelpText = "VDK service host.", Default = VdkService.Host)] public string Host { get; set; }
        [Option('p', "port", HelpText = "VDK service port.", Default = VdkService.Port)] public int Port { get; set; }
        [Option('i', "input", HelpText = "Input audio file.", Default = @"C:\Users\abdal\Music\news.wav")] public string Input { get; set; }
        [Option('r', "reference", HelpText = "Reference audio file.", Default = null)] public string Reference { get; set; } // needed for AEC (related to Barge-In)
        [Option('o', "output", HelpText = "Output audio file.", Default = "enhanced.wav")] public string Output { get; set; }
        [Option('e', "enhancer", HelpText = "Speech enhancer name.", Default = "enhancer")] public string Enhancer { get; set; }
        [Option('l', "list", HelpText = "List available enhancers.", Default = false)] public bool ListEnhancers { get; set; }
        [Option('v', "verbose", HelpText = "Verbose mode (prints debug messages).", Default = false)]
        public bool Verbose { get; set; }

        /// <summary>
        /// Validate and skip options that don't require validation and make sure the ones that do are valid.
        /// </summary>
        /// <param name="error"> The error message. </param>
        public bool Validate(out string error)
        {
            error = null;
            if (ListEnhancers) error = null;
            else if (string.IsNullOrWhiteSpace(Input) || !File.Exists(Input)) error = "Input audio file is required or does not exist.";
            else if (!string.IsNullOrWhiteSpace(Reference) && !File.Exists(Reference)) error = "Specified input reference audio file does not exist.";
            else if (string.IsNullOrWhiteSpace(Output)) error = "Output audio file is required.";
            else if (string.IsNullOrWhiteSpace(Enhancer)) error = "Speech enhancer is required.";
            return error is null;
        }
    }
}
