﻿using System;
using System.Collections.Generic;
using System.Json;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VdkServiceClient.Audio
{
    public class AudioBuffer
    {
        public byte[] Data;
        public int SampleRate = 16000;
        public int Channels = 1;
        public const int BitsPerSample = 16;

        public static AudioBuffer FromAudioPacket(JsonValue json, int sampleRate, int channels)
        {
            var buffer = new AudioBuffer();
            buffer.SampleRate = sampleRate;
            buffer.Channels = channels;
            if (json.ContainsKey("data"))
            {
                buffer.Data = Base64ToBytes(json["data"]);
            }
            return buffer;
        }

        public static List<byte[]> SplitByteArray(byte[] data, int chunkSize)
        {
            if (data == null || data.Length == 0)
            {
                return new List<byte[]>();
            }

            if (chunkSize <= 0)
            {
                byte[] copy = new byte[data.Length];
                Buffer.BlockCopy(data, 0, copy, 0, data.Length);
                return new List<byte[]>() { copy };
            }

            var chunks = new List<byte[]>((data.Length + chunkSize - 1) / chunkSize);

            for (int i = 0; i < data.Length; i += chunkSize)
            {
                int size = Math.Min(chunkSize, data.Length - i);
                byte[] chunk = new byte[size];
                Buffer.BlockCopy(data, i, chunk, 0, size);
                chunks.Add(chunk);
            }

            return chunks;
        }

        private static byte[] Base64ToBytes(string base64)
        {
            return !string.IsNullOrEmpty(base64) && base64.Length > Constants.Audio.AudioPrefix.Length
                    ? Convert.FromBase64String(base64.Substring(Constants.Audio.AudioPrefix.Length))
                    : new byte[0];
        }
    }
}
