using System;
using VdkServiceClient.Utils;
using VdkServiceClient.Http;

namespace VdkServiceClient.Api
{
    /// <summary>
    /// VDK client
    /// </summary>
    /// <remarks>
    /// Main entry point for VDK Service REST Api calls
    /// </remarks>
    public class VdkClient
    {
        public CoreApi Core { get; }
        public SpeechEnhancementApi SpeechEnhancement { get; }
        public VoiceBiometricsApi VoiceBiometrics { get; }
        public VoiceRecognitionApi VoiceRecognition { get; }
        public VoiceSynthesisApi VoiceSynthesis { get; }

        readonly string Scheme;
        readonly int Port;
        readonly string Host;
        readonly Uri BaseUri;

        public string wsUrl(string token) {
            return $"ws://{Host}:{Port}/v1/ws/{token}";
        }

        public VdkClient(string scheme, string host, int port)
        {
            Scheme            = scheme;
            Host              = host;
            Port              = port;
            BaseUri           = new Uri($"{Scheme}://{Host}:{Port}/v1");
            var http          = new HttpService(BaseUri);
            Core              = new CoreApi(http);
            SpeechEnhancement = new SpeechEnhancementApi(http);
            VoiceBiometrics   = new VoiceBiometricsApi(http);
            VoiceRecognition  = new VoiceRecognitionApi(http);
            VoiceSynthesis    = new VoiceSynthesisApi(http);

            Logger.Info($"Reaching VDK service at {BaseUri}");
        }
    } // !VdkClient
}